#include "DBaseControlWin.h"

//#include <assert.h>

namespace DWL {
    //! Constructor.
    /*! Constructor.
		    \fn			DBaseControlWin(void);
		    \return		No devuelve nada.
    */
    DBaseControlWin::DBaseControlWin(void) : DBaseWnd()  {
	    _GestorMensajesOriginal = NULL;
    };

    //! Destructor.
    /*! Destructor.
		    \fn		   ~DBaseControlWin(void);
		    \return		No devuelve nada.
    */
    DBaseControlWin::~DBaseControlWin(void) {
	    Destruir();
    };

    //! Esqueleto para los mensajes del control.
    /*! Esta funcin es el esqueleto para los mensajes del control.
		    \fn			inline virtual LRESULT CALLBACK	GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);
		    \param[in]	uMsg	: Mensaje.
		    \param[in]	wParam	: Parametro1.
		    \param[in]	lParam	: Parametro2.
		    \return		Dependiendo del mensaje y los parametros devuelve una cosa o otra.
    */
    LRESULT CALLBACK DBaseControlWin::GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam) {
/*	    switch (uMsg) {
            case WM_CHAR :
			    if (wParam == VK_TAB) {
				    if (GetKeyState(VK_SHIFT) & DWL_TECLA_PRESIONADA)	return SendMessage(GetParent(_hWnd), DWL_TAB_ANTERIOR, 0, 0);
				    else												return SendMessage(GetParent(_hWnd), DWL_TAB_SIGUIENTE, 0, 0);
			    }
                break;
            case WM_SETFOCUS :
			    SendMessage(GetParent(_hWnd), DWL_TAB_CAMBIO_FOCO, static_cast<WPARAM>(PtrToLong(this)), 0);
                break;
	    }*/
//        DEventosBase::GestorMensajes(uMsg, wParam, lParam);
	    return CallWindowProc(_GestorMensajesOriginal, _hWnd, uMsg, wParam, lParam);
        
    };

    //! Funcin que conecta este control con un dialogo.
    /*!	Esta funcin que conecta este control con un dialogo.
		    \fn			void ConectarControl(const UINT nID, DBaseWnd *Padre);
            \param[in]  nID     ID del control.
            \param[in]  nPadre  Clase DBaseWnd que hace de padre para el control.
            \return		No devuelve nada.
    */
    void DBaseControlWin::_ConectarControl(const UINT nID, DBaseWnd *nPadre) {
	    if (_hWnd != NULL && _GestorMensajesOriginal == NULL) {
            _AgregarAppBaseWnd(nID, nPadre);

		    SetWindowLongPtr(_hWnd, GWLP_USERDATA, (LONG_PTR)this);
		    _GestorMensajesOriginal = (WNDPROC)SetWindowLongPtr(_hWnd, GWLP_WNDPROC, (LONG_PTR)_GestorMensajes);
            SetWindowTheme(_hWnd, TEXT("Explorer"), NULL);
//		    SendMessage(GetParent(_hWnd), DWL_TAB_AGREGAR_CONTROL, static_cast<WPARAM>(PtrToLong(this)), 0); // Agrego el control a la lista de tabulacion
	    }
    };

    //! Funcin que destruye este control.
    /*!	Esta funcion destruye este control.
		    \fn			BOOL Destruir(void);
		    \return		Devuelve TRUE si la operacin se completo, FALSE en caso contrario.
    */
    BOOL DBaseControlWin::Destruir(void) {
	    BOOL R = DBaseWnd::Destruir();
	    _GestorMensajesOriginal = NULL;
	    return R;
    };

    //! Esqueleto inicial que enlaza esta clase con el control.
    /*! Esta funcin es el esqueleto inicial que enlaza esta clase con el control.
		    \fn			static LRESULT CALLBACK _GestorMensajes(HWND HandleVentana, UINT uMsg, WPARAM wParam, LPARAM lParam);
		    \param[in]	HandleVentana	: Identificador de ventana.
		    \param[in]	uMsg			: Mensaje.
		    \param[in]	wParam			: Parametro1.
		    \param[in]	lParam			: Parametro2.
		    \return		Dependiendo del mensaje y los parametros devuelve una cosa o otra.
    */
    LRESULT CALLBACK DBaseControlWin::_GestorMensajes(HWND HandleVentana, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	    DBaseControlWin *Control = reinterpret_cast<DBaseControlWin *>(GetWindowLongPtr(HandleVentana, GWLP_USERDATA));
	    if (Control == NULL) return FALSE;
//        assert(Control->_hWnd == HandleVentana);
        LRESULT Ret = 0;
        if (uMsg == WM_PAINT) {
            return (Control->_GestorMensajesOriginal)(HandleVentana, uMsg, wParam, lParam);
            //Control->GestorMensajes(uMsg, wParam, lParam);
        }
        else {
            Ret = Control->GestorMensajes(uMsg, wParam, lParam);
            if (Ret == DWL_USAR_GESTOR_POR_DEFECTO) {
                return (Control->_GestorMensajesOriginal)(HandleVentana, uMsg, wParam, lParam);
            }
        }
	    return Ret;
    };
};